\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{fiche}[2025/11/22 FMR fiche]

% ---------------------------------------------
% Process class options (language selection)
% ---------------------------------------------
\newif\iffiche@french
\DeclareOption{french}{\fiche@frenchtrue}
\DeclareOption{english}{\fiche@frenchfalse}

% Default language : English
\ExecuteOptions{english}

\ProcessOptions\relax

% ---------------------------------------------
% Load base class
% ---------------------------------------------
\LoadClass[a4paper,11pt]{article}

% ---------------------------------------------
% Essential packages (locked)
% ---------------------------------------------
\RequirePackage[T1]{fontenc}
\RequirePackage{lmodern}
\RequirePackage{microtype}

% Mathematics
\RequirePackage{amsmath,amssymb,amsthm}
\RequirePackage{mathtools}

% Figures and graphics
\RequirePackage{graphicx}
\RequirePackage{xcolor}

% Textual utilities
\RequirePackage{csquotes}

% ---------------------------------------------
% Language support
% ---------------------------------------------
% Load babel according to chosen language
\RequirePackage[french,english]{babel}

% Options before the language selection
% After loading enumitem
\RequirePackage{enumitem}

% Consistent spacing for all itemize levels
\setlist[itemize]{%
    topsep=0.5em,      % vertical space above/below list
    partopsep=0pt,     % extra space when starting a paragraph
    parsep=0pt,        % paragraph separation inside items
    itemsep=0.25em,    % space between items
    left=0pt           % no extra left indent
}
\setlist[enumerate]{%
    topsep=0.5em,
    partopsep=0pt,
    parsep=0pt,
    itemsep=0.25em,
    left=0pt
}
\setlist[itemize,1]{label=\textbullet}
\setlist[itemize,2]{label=--}
\setlist[itemize,3]{label=*}

\iffiche@french
  \selectlanguage{french}
  \usepackage{hyphenat}
\else
  \selectlanguage{english}
\fi

% ---------------------------------------------
% Basic Tikz (locked)
% ---------------------------------------------
\RequirePackage{tikz}
\usetikzlibrary{arrows.meta,positioning,calc}

% ---------------------------------------------
% Page geometry (locked)
% ---------------------------------------------
\RequirePackage{geometry}
\geometry{
    top=2cm,
    bottom=2cm,
    left=2cm,
    right=2cm,
    marginparwidth=1.75cm,
    includeheadfoot
}

% ---------------------------------------------
% Hyperref (locked)
% ---------------------------------------------
\RequirePackage[
    colorlinks=true,
    linkcolor=blue,
    citecolor=blue,
    urlcolor=blue,
    pdfusetitle,
    bookmarksnumbered=true
]{hyperref}

% ---------------------------------------------
% Fiche metadata system
% ---------------------------------------------
\makeatletter

\renewcommand{\maketitle}{%
  \newpage
  \null
  \vskip 2em%
  \begin{center}%
  \let \footnote \thanks
    {\LARGE \@title \par}%
    \vskip 1.5em%
    {\large \@date}%
  \end{center}%
  \par
  \vskip 1.5em
}

% Storage macros (initially empty)
\def\@ficheDiscipline{}
\def\@ficheYear{}
\def\@ficheCourse{}

% Public setters
\newcommand{\discipline}[1]{\def\@ficheDiscipline{#1}}
\newcommand{\ficheyear}[1]{\def\@ficheYear{#1}}
\newcommand{\course}[1]{\def\@ficheCourse{#1}}

% ---------------------------------------------
% Language-dependent labels
% ---------------------------------------------
\newcommand{\ficheLabelDiscipline}{%
  \iffiche@french Discipline\else Subject\fi
}
\newcommand{\ficheLabelAuthor}{%
  \iffiche@french Auteur\else Author\fi
}
\newcommand{\ficheLabelYear}{%
  \iffiche@french Année\else Year\fi
}
\newcommand{\ficheLabelCourse}{%
  \iffiche@french Cours\else Course\fi
}

% ---------------------------------------------
% Errors
% ---------------------------------------------
\newcommand{\ficheWarnMissing}[1]{%
  \PackageError{fiche}{Missing information: #1}%
}

% ---------------------------------------------
% Print metadata table
% ---------------------------------------------
\newcommand{\ficheinfo}{%
  % Warnings
  \ifx\@ficheDiscipline\@empty \ficheWarnMissing{\ficheLabelDiscipline}\fi
  \ifx\@ficheYear\@empty       \ficheWarnMissing{\ficheLabelYear}\fi
  \ifx\@ficheCourse\@empty     \ficheWarnMissing{\ficheLabelCourse}\fi

  % Print table
  \begin{center}
    \begin{tabular}{|l|p{0.6\textwidth}|}
    \hline
    \textbf{\ficheLabelDiscipline} & \@ficheDiscipline \\ \hline
    \textbf{\ficheLabelAuthor}     & \@author          \\ \hline
    \textbf{\ficheLabelYear}       & \@ficheYear       \\ \hline
    \textbf{\ficheLabelCourse}     & \@ficheCourse     \\ \hline
    \end{tabular}
  \end{center}
}

\makeatother

% ---------------------------------------------
% End of class
% ---------------------------------------------
